/*
 * Decompiled with CFR 0.152.
 */
package com.stampysoft.ant.j2me;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class UpdateJARSizeTask
extends Task {
    private static final String MIDLET_JAR_SIZE = "MIDlet-Jar-Size";
    private File m_jad;
    private boolean m_relativePath = false;

    public void setJad(File file) {
        this.m_jad = file;
    }

    public void setRelativePath(boolean bl) {
        this.m_relativePath = bl;
    }

    public void execute() throws BuildException {
        if (this.m_jad == null) {
            throw new BuildException("You must specify a JAD file with the \"jad\" attribute", this.location);
        }
        if (!this.m_jad.isFile()) {
            throw new BuildException("The specified JAD file, " + this.m_jad + " either does not exist or is not a file", this.location);
        }
        try {
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(this.m_jad);
            properties.load(fileInputStream);
            fileInputStream.close();
            String string = properties.getProperty("MIDlet-Jar-URL");
            if (string == null) {
                throw new BuildException("No JAR file specified in the JAD with the \"MIDlet-Jar-URL\" property", this.location);
            }
            File file = null;
            if (string.startsWith("file://")) {
                string = string.substring("file://".length());
                file = this.m_relativePath ? new File(this.m_jad.getParent(), string) : new File(string);
            } else {
                file = new File(this.m_jad.getParent(), string);
            }
            if (!file.isFile()) {
                throw new BuildException("The JAR file specified in the JAD, " + file + ", either does not exist or is not a file", this.location);
            }
            String string2 = Long.toString(file.length());
            if (!string2.equals(properties.getProperty(MIDLET_JAR_SIZE))) {
                this.log("Updating " + this.m_jad + " with new JAR size of " + string2);
                properties.setProperty(MIDLET_JAR_SIZE, string2);
                FileOutputStream fileOutputStream = new FileOutputStream(this.m_jad);
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                Iterator<Object> iterator = properties.keySet().iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    printWriter.print(string3);
                    printWriter.print(": ");
                    printWriter.println(properties.getProperty(string3));
                }
                printWriter.close();
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Problem processing the JAD file: " + iOException.getMessage(), this.location);
        }
    }
}

